 
//

#import "LuLuConnector.h"

#if defined(__cplusplus)
extern "C" {
#endif
    extern NSString* LoginKitCreateNSString (const char* string);
    extern char* LoginKitMakeStringCopy(const char*string);
    extern void UnitySendMessage(const char *, const char *, const char *);
#pragma mark - SDK 平台接口调用
    void LuluSetListener(const char *gameObjectName){
        [[LuLuConnector shareInstance] setListener:LoginKitCreateNSString(gameObjectName)];
    }
    void luLuInit(){
        //设置回调
        [REDeLoginKit setFunctionLoginCallback:[LuLuConnector shareInstance]];
        [REDeLoginKit setFunctionBuyCallback:[LuLuConnector shareInstance]];
        [REDeLoginKit restoreNonConsumptionProducts:[LuLuConnector shareInstance]];
        // 初始化
        [REDeLoginKit initSDKWithProductCode:@"xxxxxxxxxxxx" callback:[LuLuConnector shareInstance]];  /** productCode到sdk后台获取, 请务必修改为自己的参数  */
    }
    /** 显示登陆界面 */
    void luLuLogin(BOOL isShowMenu){
        [REDeLoginKit loginWithMenuShow:isShowMenu];
    }
     /** 固定调起某个三方登录 */
    void luLuLoginWithType(int type){
        [REDeLoginKit loginAccountType:(USERCENTER_TYPE)type];
    }
    /** 静默登录不显示登陆界面 */
    void luLuFastStartGame(){
        [REDeLoginKit fastlyStartGame];
    }
    /** 获取userid */
    const char * LuluGetUserId(){
        NSString * userId = [REDeLoginKit userID];
        return LoginKitMakeStringCopy([userId UTF8String]);
    }
    /** 获取SDK设备ID */
    const char * LuluGetDeviceId(){
        NSString * deviceId = [REDeLoginKit getDeviceID];
        return LoginKitMakeStringCopy([deviceId UTF8String]);
    }
    /** 注销登陆 */
    void luLuLogout(){
        [REDeLoginKit logout];
    }
    /** 显示个人中心  */
    void luLuUserCenter(){
        [REDeLoginKit enterUserCenter];
    }
     /** 获取三方绑定信息  */
    const char * luLuGetUserBindInfo(){
        NSDictionary * resultDict = [REDeLoginKit getUserBindInfo];
        NSString *jsonStr = [[LuLuConnector shareInstance] dictionaryToJson:resultDict];
        return LoginKitMakeStringCopy([jsonStr UTF8String]);
    }
     /** 进入三方绑定界面  */
    void luLuBindAccount(){
        [REDeLoginKit bandAccount];
    }
     /** 绑定三方账号  */
    void luLuBindAccountWithType(int type){
        [REDeLoginKit bindAccountType:(USERCENTER_TYPE)type];
    }
     /** 解绑三方账号  */
    void luLuUnbindAccountWithType(int type){
        [REDeLoginKit unbindAccount:(USERCENTER_TYPE)type];
    }
     /** 删除当前登录账号  */
    void luLuAccountDeletion(){
        [REDeLoginKit accountDeletion];
    }
    /** 删除当前登录账号, 没有确认框  */
    void luLuAccountDeletionWithoutConfirm(){
        [REDeLoginKit accountDeletionWithoutConfirm];
    }
     /** 显示悬浮窗  */
    void luLuShowMenu(float y){
        [REDeLoginKit showFloatButtonIsLeft:YES buttonOriginalY:y > 0 ? y:40];
    }
     /** 隐藏悬浮窗  */
    void luLuDismissMenu(){
        [REDeLoginKit dismissMenu];
    }
    /** 上报角色信息 */
    void luluSetRoleInfo(const char *serverName,const char *serverId,const char *roleId,const char *roleName,const char *roleLevel,const char *roleVipLevel){
        REDeRoleInfo * role = [[REDeRoleInfo alloc]init];
        role.server_name = LoginKitCreateNSString(serverName);
        role.server_id = LoginKitCreateNSString(serverId);
        role.game_role_name = LoginKitCreateNSString(roleName);
        role.game_role_id = LoginKitCreateNSString(roleId);
        role.game_role_level = LoginKitCreateNSString(roleLevel);
        role.vip_level = LoginKitCreateNSString(roleVipLevel);
        [REDeLoginKit setGameRoleInfo:role];
    }
    /** 调用下单方法 */
    void luLuCongzi(const char *productId,const char *productName,char * amount,const char *orderNo,const char *callBackUrl,const char *extrasParams){
        REDeOrderInfo *param = [[REDeOrderInfo alloc] init];
        param.productId = LoginKitCreateNSString(productId);    ///设置商品ID，苹果后台对应的productID
        param.subject = LoginKitCreateNSString(productName);    ///商品名称 必填
        param.total = LoginKitCreateNSString(amount);                       ///商品总价 必填
        param.product_order_no = LoginKitCreateNSString(orderNo);       ///游戏方订单号 string[64] 接入QuickAd时必填、必须唯一
        param.callback_url = LoginKitCreateNSString(callBackUrl);       ///回调通知地址 string[200] 可选  客户端配置优先;  可传nil
        param.extras_params = LoginKitCreateNSString(extrasParams);     ///透传参数  可选
        [REDeLoginKit IAPWithParameter:param];
    }
    /** 恢复历史内购 */
    void luluRestoreNonConsumptionProducts(){
        [REDeLoginKit restoreNonConsumptionProducts:[LuLuConnector shareInstance]];
    }
    /** 通过商品ids数组查找商品信息 */
    void luluFindProductInfo(const char *productIds){
        NSString * productIdStr = LoginKitCreateNSString(productIds);
        NSArray * productIdArr = [[LuLuConnector shareInstance] arrFromJsonStr:productIdStr];
        if (productIdArr.count) {
            [REDeLoginKit findProductInfoWithProductIds:productIdArr delegate:(id)[LuLuConnector shareInstance]];
        } else {
            [[LuLuConnector shareInstance] sendU3dMessage:@"findProductInfoFail" parameters:@"productids is not json string"];
        }
    }
    /** 打开评价界面 appid用于应用内评分界面无法使用时跳转到AppStore应用详情页编辑评论可为空， 传空则不跳转  */
    void luluShowAppCommentWithAppID(const char *appid) {
        [REDeLoginKit showAppCommentWithAppID:LoginKitCreateNSString(appid)];
    }
    /** AliNetworkDiagnosis初始化 */
    void initAliNetworkDiagnosis(const char *secretKey, const char *deviceId, const char *siteId, const char *extension) {
        NSDictionary * extDict = [[LuLuConnector shareInstance] dictionaryFromJsonStr:LoginKitCreateNSString(extension)];
        [REDeLoginKit aLiNetworkDiagnosisInitWithSecretKey:LoginKitCreateNSString(secretKey) deviceId:LoginKitCreateNSString(deviceId) siteId:LoginKitCreateNSString(siteId) extParamsDict:extDict];
    }
    /** AliNetworkDiagnosis-HTTP探测*/
    void startHttpPingAliNetworkDiagnosis(const char *url, const char *traceId) {
        [REDeLoginKit aLiNetworkDiagnosisStartHttpPingUrl:LoginKitCreateNSString(url) traceId:LoginKitCreateNSString(traceId) context:nil resultBlock:nil];
    }
    /** AliNetworkDiagnosis-PING探测*/
    void startPingAliNetworkDiagnosis(const char *host,int timeout,int interfaceType,int prefer,const char *traceId,int size,int count,int timeInterval) {
        [REDeLoginKit aLiNetworkDiagnosisStartPingUrl:LoginKitCreateNSString(host) timeout:timeout interfaceType:(AliNetDiagNetworkInterfaceType)interfaceType prefer:prefer traceId:LoginKitCreateNSString(traceId) context:nil size:size count:count interval:timeInterval resultBlock:nil combineResultBlock:nil];
    }
    /** AliNetworkDiagnosis-TCP探测*/
    void startTcpPingAliNetworkDiagnosis(const char *host,int timeout,int interfaceType,int prefer,const char *traceId,int port,int count,int timeInterval) {
        [REDeLoginKit aLiNetworkDiagnosisStartTcpPingUrl:LoginKitCreateNSString(host) timeout:timeout interfaceType:(AliNetDiagNetworkInterfaceType)interfaceType prefer:prefer traceId:LoginKitCreateNSString(traceId) context:nil port:port count:count interval:timeInterval resultBlock:nil combineResultBlock:nil];
    }
    /** AliNetworkDiagnosis-MTR探测*/
    void startMtrPingAliNetworkDiagnosis(const char *host,int maxTtl,int maxPaths,int maxTimeEachIP,int timeout,int interfaceType,int prefer,const char *traceId) {
        [REDeLoginKit aLiNetworkDiagnosisStartMtrUrl:LoginKitCreateNSString(host) maxTtl:maxTtl maxPaths:maxPaths maxTimeEachIP:maxTimeEachIP timeout:timeout interfaceType:(AliNetDiagNetworkInterfaceType)interfaceType prefer:prefer traceId:LoginKitCreateNSString(traceId) context:nil resultBlock:nil combineResultBlock:nil];
    }
    /** AliNetworkDiagnosis-DNS探测*/
    void startDnsAliNetworkDiagnosis(const char *host,const char *nameServer,const char *type,int timeout,int interfaceType,const char *traceId) {
        [REDeLoginKit aLiNetworkDiagnosisStartDnsUrl:LoginKitCreateNSString(host) nameServer:LoginKitCreateNSString(nameServer) type:LoginKitCreateNSString(type) timeout:timeout interfaceType:(AliNetDiagNetworkInterfaceType)interfaceType traceId:LoginKitCreateNSString(traceId) context:nil resultBlock:nil];
    }
    NSString* LoginKitCreateNSString (const char* string)
    {
        if (string)
            return [NSString stringWithUTF8String: string];
        else
            return [NSString stringWithUTF8String: ""];
    }
    char* LoginKitMakeStringCopy(const char*string) {
        if (string == NULL) {
            return NULL;
        }
        char*res = (char*)malloc(strlen(string)+1);
        strcpy(res, string);
        return res;
    }
#if defined(__cplusplus)
}
#endif

@implementation LuLuConnector

+(LuLuConnector *)shareInstance{
    
    static LuLuConnector *shareInstance = nil;
    static dispatch_once_t predicate;
    dispatch_once(&predicate, ^{
        shareInstance = [[LuLuConnector alloc] init];
    });
    return shareInstance;
}
//MARK: - 回调
// 初始化结果回调
- (void)qgSDKInitDone {
    // 初始化成功
    if (_U3dInited) {
        [self sendU3dMessage:@"onInitSuccess" parameters:@"Init:Init Success"];
        return;
    }
    _initSuccess = YES;
}
// 登录回调
- (void)loginUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type {
    NSDictionary * resultDict = @{@"uid":uid, @"token":token, @"loginType":@(type).stringValue, @"isNewUser":@(REDeLoginKit.isNewUser).stringValue, @"isGuest":@(REDeLoginKit.isUserGuest).stringValue};
    [self sendU3dMessage:@"onLoginSuccess" parameters:[self dictionaryToJson:resultDict]];
}
//绑定回调
- (void)bindUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type
{
    NSDictionary * resultDict = @{@"uid":uid, @"token":token, @"loginType":@(type).stringValue};
    [self sendU3dMessage:@"onBindSuccess" parameters:[self dictionaryToJson:resultDict]];
}
//解绑回调
- (void)unBindUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type
{
    NSDictionary * resultDict = @{@"uid":uid, @"token":token, @"loginType":@(type).stringValue};
    [self sendU3dMessage:@"onUnBindSuccess" parameters:[self dictionaryToJson:resultDict]];
}
/** 游戏调用logout操作完成回调 */
- (void)gameLogoutSuccess {
    [self sendU3dMessage:@"onGameLogoutSuccess" parameters:@"game Logout"];
}
//在SDK的个人中心主动退出登录
- (void)userLogout{
    NSLog(@"用户从个人中心手动登出。");
    [self sendU3dMessage:@"onLogoutSuccess" parameters:@"Log out"];
}
//支付结果的回调
//购买完成 内购商品Id SDK订单号
- (void)purchaseDoneProductId:(NSString *)productId orderNo:(NSString *)orderNo gameOrderNo:(NSString *)gameOrderNo appStoreReceiptBase64EncodedString:(NSString *)receiptString {
    NSMutableDictionary * resultDict = [NSMutableDictionary dictionary];
    [resultDict setObject:productId forKey:@"productId"];
    [resultDict setObject:orderNo forKey:@"orderNo"];
    [resultDict setObject:gameOrderNo forKey:@"gameOrderNo"];
    [resultDict setObject:receiptString forKey:@"receiptString"];
    [self sendU3dMessage:@"onPurchaseSuccess" parameters:[self dictionaryToJson:resultDict]];
}
//购买失败
- (void)purchaseFail{
    [self sendU3dMessage:@"onPurchaseFail" parameters:@""];
}
//恢复非消耗商品成功，返回商品id信息
- (void)restoreSuccess:(NSArray *)products
{
    [self sendU3dMessage:@"onRestoreSuccess" parameters:[self jsonStrFromArr:products]];
}
//恢复失败
- (void)restoreFail:(NSString *)msg
{
    [self sendU3dMessage:@"onRestoreFail" parameters:msg];
}
//查找商品信息成功数组元素为REDeOrderInfo实例
- (void)findProductInfoSuccess:(NSArray *)products {
    NSMutableArray * arr = [[NSMutableArray alloc]init];
    for (REDeOrderInfo * info in products) {
//        NSLog(@"查询商品信息成功结果：商品id=%@,商品名称=%@，商品描述=%@，商品价格=%@，商品总价=%@，透传参数=%@",info.productId, info.subject, info.desc, info.price, info.total, info.extras_params);
        [arr addObject:@{@"productId":info.productId, @"productName":info.subject, @"productDesc":info.desc, @"price":info.price, @"total":info.total, @"extras_params":info.extras_params}];
    }
    NSString *jsonStr = [self jsonStrFromArr:arr];
    [self sendU3dMessage:@"findProductInfoSuccess" parameters:[self jsonStrFromArr:arr]];
}
//查找商品信息失败
- (void)findProductInfoFail:(NSString *)msg {
    [self sendU3dMessage:@"findProductInfoFail" parameters:msg];
}
- (void)setListener:(NSString *)gameObjectName
{
    _gameObjectName = gameObjectName;
    _U3dInited = YES;
    if (_initSuccess)//初始化成功
    {
        [self sendU3dMessage:@"onInitSuccess" parameters:nil];
        _initSuccess = NO;
    }
}
- (void)sendU3dMessage:(NSString *)messageName parameters:(NSString *)parameters {
    if (!_gameObjectName) {
        NSLog(@"U3D not set listener");
        return;
    }
    if ([parameters isKindOfClass:NSString.class] && [parameters length]) {
        UnitySendMessage([_gameObjectName UTF8String], [messageName UTF8String], [parameters UTF8String]);
    }
    else{
        UnitySendMessage([_gameObjectName UTF8String], [messageName UTF8String], "");
    }
}
- (NSString *)jsonStrFromArr:(NSArray *)arr {
    NSError *error = nil;
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:arr options:0 error:&error];
    if ([error code]) {
        return @"";
    }
    return [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
}
- (NSArray *)arrFromJsonStr:(NSString *)string {
    NSError *error = nil;
    NSData* data = [string dataUsingEncoding:NSUTF8StringEncoding];
    id jsonObject = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers|NSJSONReadingMutableLeaves error:nil];
    if ([jsonObject isKindOfClass:NSArray.class]) {
        return jsonObject;
    }
    return @[];
}
- (NSDictionary *)dictionaryFromJsonStr:(NSString *)string {
    NSError *error = nil;
    NSData* data = [string dataUsingEncoding:NSUTF8StringEncoding];
    id jsonObject = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers|NSJSONReadingMutableLeaves error:nil];
    if ([jsonObject isKindOfClass:NSDictionary.class]) {
        return jsonObject;
    }
    return @{};
}
- (NSString*)dictionaryToJson:(NSDictionary *)dic
{
    NSError *parseError = nil;
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dic options:NSJSONWritingPrettyPrinted error:&parseError];
    return [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
}
@end
